﻿// Copyright (c) Microsoft Corporation.  All rights reserved.
var elsFramework = new ELSFramework();
var testStatusView = new TestStatusView(elsFramework);
window.onerror = function (msg, url, linenumber) {
    //Don't throw alert - we should land here as result of code flaw only, doesnot make sense to keep throwing popups on UI for such issues.
    elsFramework.LogError("ScriptedSandbox.exe, Msg: " + msg + " Url: " + url + " Line: " + linenumber);
    return true;
}
function TestStatusView(framework) {
    var testRunMonitor = new TestRunMonitor(framework);
    var reportDownloader = new ReportDownloader({
        Callbacks: {
            OnBeginDownload: onBeginDownload,
            OnDownloadFailure: onDownloadFailure,
            OnDownloadComplete: onDownloadComplete,
            OnDownloadStatusUpdate: onDownloadStatusUpdate
        }
    }, framework);
    var userCancelled = false;
    var stopInitiated = false;
    var testProgressBar = null;
    var currentSelectedKpiGroup = null;
    var currentGraph = null;
    var prevKpiSelected = null;
    var testRunMessages = null;
    var kpiList = [];
    var loadTestRunning = false;
    var instance = this;
    var tabsConfigured = false;
    var graphsTabEnabled = false;
    var resource = framework.GetResource();
    var webConfiguration = framework.GetWebConfiguration();
    var isErrorInAut = false;
    var runMonitorStarted = false;
    var applicationTabName = "Application";
    this.TestName = "";
    this.TfsUrl = "";
    

    function showStopButton() {
        if (userCancelled != true) {
            $("#stopButton").show();
            $("#stopButton").prop('disabled', false);
        }
    }

    function onBeginDownload() {
        elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_ViewDetailedResultsAfterDownloadAvailableStart);
        $("#downloadStatus").html(resource.GetString("DownloadStarting"));
        $("#testResultSection").hide();
    }

    function onDownloadFailure(errorMessage) {
        framework.LogError("Download report error: " + errorMessage);
        $("#downloadStatus").html("");
        $("#testResultSection").show();
        var downloadError = [];
        downloadError.push("<div>" + errorMessage + "</div>");
        ShowBasicDialog($("#infoSection"), resource.GetString("ErrorDetailsTag"), downloadError);
    }

    function onDownloadComplete(finishTimeString) {
        $("#downloadStatus").html("");
        $("#testEndDateTimeLabel").html(resource.GetString("LastDownloadedLabel"));
        $("#testEndDateTime").html(finishTimeString);
        $("#runDurationLabel").hide();
        $("#runDuration").hide();
        $("#testResultSection").show();
        elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_ViewDetailedResultsAfterDownloadAvailableEnd);
        elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_ViewDetailedResultsAfterRunCompletedEnd);
    }

    function onDownloadStatusUpdate(statusMessage) {
        $("#downloadStatus").html(statusMessage);
    }

    function showProgressBar(testRun) {
        testProgressBar = null;
        testProgressBar = new ProgressTimer($("#progressBar"), $("#progressCurrentTime"), $("#progressTotalTime"));
        var dateTimeEncoding = framework.GetWebConfiguration().DateTimeEncoding;
        var startTime = (new DateTime(testRun.ExecutionStartedDate, dateTimeEncoding)).GetJSDate();
        testProgressBar.StartProgress(startTime, testRun.RunSpecificDetails.Duration);
        $("#progressBarSection").show();
    }

    function showWarmUpProgressBar(testRun) {
        var dateTimeEncoding = framework.GetWebConfiguration().DateTimeEncoding;
        var startTime = (new DateTime(testRun.WarmUpStartedDate, dateTimeEncoding)).GetJSDate();
        testProgressBar.StartProgress(startTime, testRun.RunSpecificDetails.WarmUpDuration);
        $("#progressBarSection").show();
    }

    function onTestStatusUpdate(testRun, testState) {
        
        if (testRun.LoadGenerationGeoLocations != null) {
            var location = testRun.LoadGenerationGeoLocations.map(function (value, index) { return value["Location"]; }).join(",");
            instance.ShowLocationInformation(location);
        }

        

        $("#intermittentErrorDetails").dialog('close');
        if (testState.AbortMessage !== undefined && testState.AbortMessage !== null) {
            $("#testRunMessageSection").html(
            testState.AbortMessage.Cause + " "
            + testState.AbortMessage.Action
            );
            $("#viewDetails").html(
            "<a id=\"viewdetails\">"
            + resource.GetString("ViewDetailsLink") + "</a>"
            );

            var newHTML = [];
            newHTML.push('<div UNSELECTABLE="off">' + testState.AbortMessage.Cause + " "
            + testState.AbortMessage.Action + '</div><br>');
            $.each(testState.AbortMessage.Details, function (index, value) {
                newHTML.push('<br><div UNSELECTABLE="off">' + value + '</div>');
            });
            $("#viewdetails").click(function () {
                var header = resource.GetString("TestRunHeader") + " " + testState.ToUIString();
                ShowBasicDialog($("#messageDetails"), header, newHTML);
            });
        }

        if ($("#pageTitle").hasClass("status-progress")) {
            $("#pageTitle").removeClass("status-progress");
        }

        if (userCancelled == true && stopInitiated != true) {
            stopInitiated = true;
            stopRun();
            // Don't continue if we are calling stopRun, as it will call this function again.
            return;
        }
        else {
            $("#pageTitle").html(resource.GetString("PageTitle", instance.TestName, testState.ToUIString()));
            framework.ReportCaptionChange(testState.ToUIString(), testRun.RunNumber);
        }

        if (testState.IsInProgress()) {
            $("#stopButton").html(resource.GetString("StopButtonCaption"));
            $("#stopButton").unbind('click').click(stopRun);
            $("#testStatusImage").attr({
                'src': Plugin.Theme.getValue('TestInProgress'),
                'data-plugin-theme-src': 'TestInProgress'
            });
            showStopButton();
        }
        else if (testState.IsStopping()) {
            $("#progressBarSection").hide();
            $("#testStatusImage").attr({
                'src': Plugin.Theme.getValue('TestAborted'),
                'data-plugin-theme-src': 'TestAborted'
            });
            $("#stopButton").prop('disabled', true);
        }
        else if (testState.IsFinished()) {
            $("#stopButton").hide();
            if (testState.IsAborted()) {
                instance.SetTestAbortedView(null);
            } else if (testState.IsFailed()) {
                instance.SetTestFailedView(testRun.ErrorMessage);
            } else {
                $("#testStatusImage").attr({
                    'src': Plugin.Theme.getValue('TestCompleted'),
                    'data-plugin-theme-src': 'TestCompleted'
                });
            }
            onTestCompleted(testRun, testState);
        }

        if (testState.IsQueued()) {
            $("#stopButton").html(resource.GetString("StopButtonCaption"));
            $("#stopButton").unbind('click').click(stopRun);
            $("#testSubStatus").html("");
            showStopButton();
        }

        if (tabsConfigured == false) {
            configureTabs(testState);
        }
            
        onSubStatusUpdate(testRun, testState);

    }

    function onSubStatusUpdate(testRun, testState) {
        if (testRun.LoadGenerationGeoLocations != null) {
            var location = testRun.LoadGenerationGeoLocations.map(function (value, index) { return value["Location"]; }).join(",");
            instance.ShowLocationInformation(location);
        }

        if ((userCancelled === true && (testState.IsFinished() === false && testState.IsStopping() === false))) {
            return;
        }
        
        if (testState.IsLoadTestStarted()) {
            showProgressBar(testRun);
            loadTestRunning = true;
            $("#testSubStatus").html(testState.GetSubStatus());
        } else {
            switch (testState.SubState) {
                case TestRunSubState.ValidatingTestRun:
                    $("#testSubStatus").html(resource.GetString("ValidatingTestRun"));
                    break;
                case TestRunSubState.AcquiringResources:
                    $("#testSubStatus").html(resource.GetString("AcquiringResources"));
                    break;
                case TestRunSubState.ConfiguringAgents:
                    $("#testSubStatus").html(resource.GetString("ConfiguringAgents"));
                    break;
                case TestRunSubState.ExecutingSetupScript:
                    $("#testSubStatus").html(resource.GetString("RunningSetupScript"));
                    break;
                case TestRunSubState.WarmingUp:
                    $("#testSubStatus").html(resource.GetString("WarmingUp"));
                    showWarmUpProgressBar(testRun);
                    break;
                case TestRunSubState.ExecutingCleanupScript:
                    $("#progressBarSection").hide();
                    $("#testSubStatus").html(resource.GetString("RunningCleanupScript"));
                    break;
                case TestRunSubState.CollectingResults:
                    $("#stopButton").prop('disabled', true);
                    $("#progressBarSection").hide();
                    $("#testSubStatus").html(resource.GetString("CollectingResults"));
                    break;
                default:
                    $("#testSubStatus").html(testState.GetSubStatus());
            }
        }
    }

    function configureTabs(testState) {
        $("#detailsTab").html(resource.GetString("GraphTabLabel"));
        $("#messagesTab").html(resource.GetString("MessageTabLabel"));
        $("#hub").addClass("hub-view explorer work-items-view triage-view");
        $("#hubContent").addClass("hub-content");
        if (testState.State >= LoadTestRunState.InProgress &&
            testState.SubState >= TestRunSubState.RunningTest) {
            $("#tabs").tabs({ show: showMessagesTab });
            graphsTabEnabled = true;
        } else {
            $("#tabs").tabs({ selected: 1, disabled: [0], show: showMessagesTab });
        }
        tabsConfigured = true;
    }

    function onTestMessagesReceived(testMessages) {
        var allRequiredAutMessages = $.grep(testMessages, function (message, index) {
            return (message.MessageSource == 4 && message.MessageType > 0);
        });

        if (allRequiredAutMessages.length > 0) {
            isErrorInAut = true;
            showAutErrorIcon();
        }
    }

    function showAutErrorIcon() {
        var autInfoId = "#kpiInfo_" + applicationTabName;
        if ($(autInfoId).length > 0 && (!$(autInfoId).hasClass('kpiInfoShow'))) {
            $(autInfoId).removeClass();
            $(autInfoId).addClass('kpiInfoShow');
            if (currentGraph != null) {
                if (currentGraph.isAutGraph()) {
                    currentGraph.showErrorDiv();
                }
            }
        }
    }

    function onKpiAvailable(kpis) {
        if (graphsTabEnabled == false && tabsConfigured == true) {
            $("#tabs").tabs("enable", 0);
            if (testRunMessages != null)
                testRunMessages.Hide();
            graphsTabEnabled = true;
        }
        kpiList = kpis;
        var testSErviceClient = elsFramework.GetTestServiceClient();
        testSErviceClient.GetApplicationType(function(appType) {
            if (appType.IsEnabled) {
                var autKpiGroupAdded = false;
                $.each(kpiList, function (kpiIndex, kpi) {
                    if (kpi.GroupName === applicationTabName) {
                        autKpiGroupAdded = true;
                    }
                });

                if (autKpiGroupAdded === false) {
                    kpiList.push({ GroupName: applicationTabName, CounterInstances: [] });
                }
            }
            showGraph();
            
            $("#tabs").tabs("select", 0);
            
        });
    }

    function onKpiGroupClick() {
        var isSwitchKpi = false;
        if (prevKpiSelected != null && prevKpiSelected.id != this.id) {
            elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_ShowGraphOnFirstSwitchStart);
            elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_ShowNextSampleOnSwitchStart);
            elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_ShowAllSamplesOnSwitchStart);
            isSwitchKpi = true;
        }
        if (this.id == "kpi_Application") {
            onKpiGroupClick.applicationTabClickCount = ++onKpiGroupClick.applicationTabClickCount || 1;
            if (onKpiGroupClick.applicationTabClickCount == 1) {
                elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_ShowCountersDefinitionsInApplicationTabStart);
                elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_GetFirstGraphCounterOnApplicationTabStart);
            }
        }

        if (currentSelectedKpiGroup == this) {
            return;
        }

        if (currentSelectedKpiGroup != null) {
            $(currentSelectedKpiGroup).removeClass("kpiButtonSelected");
            $(currentSelectedKpiGroup).addClass("kpiButtonHover");
        }
        $(this).removeClass("kpiButtonHover");
        $(this).addClass("kpiButtonSelected");
        currentSelectedKpiGroup = this;

        if (currentGraph != null) {
            currentGraph.Hide();
        }

        var kpiGroup = $(this).data("kpiGroupElement");
        currentGraph = $(this).data("kpiGraph");

        if (typeof currentGraph == 'undefined') {
            currentGraph = new TestRunGraph(kpiGroup, $("#graphArea"), $("#legendSection"), testRunMonitor, framework);
            $(this).data("kpiGraph", currentGraph);
            elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_GetFirstGraphCounterStart);
        }

        currentGraph.Show(isSwitchKpi);
        
        prevKpiSelected = this;
        
    }

    function showGraph() {

        if (kpiList.length == 0) {
            return;
        }
        var firstKpi = null;
        $("#kpiListSection").html("");
        $.each(kpiList, function (index, element) {
            var buttonId = "kpi_" + element.GroupName;
            var buttonInfoId = "kpiInfo_" + element.GroupName;
            $("#kpiListSection").append("<div class='generalButton'><div id=\"" + buttonId + "\" class=\"kpiButton kpiButtonHover\" tabindex='" + 0 + "'><div class=\"kpiButtonText\">" + element.GroupName + "</div></div><div id=\"" + buttonInfoId + "\" ></div></div>");
            $("#" + buttonId).click(onKpiGroupClick);
            $("#" + buttonId).data("kpiGroupElement", element);

            if (firstKpi == null) {
                firstKpi = buttonId;
            }
        });
        var testServiceClient = elsFramework.GetTestServiceClient();
        
        testServiceClient.GetApplicationType(function (appType) {
            if (appType.IsEnabled) {
                if (isErrorInAut) {
                    showAutErrorIcon();
                }
            }

            if (firstKpi != null) {
                $("#" + firstKpi).click();
            }
        });
    }

    function onTestCompleted(testRun, testState) {
        testRunMonitor.StopMonitoring();
        framework.CheckResultStatus(testRun.Id);

        testProgressBar.StopProgress();
        $("#progressBarSection").hide();

        if (userCancelled == true && testRunMonitor.IsTestStarted() == false) {
            return;
        }

        try {
            var dateTimeEncoding = framework.GetWebConfiguration().DateTimeEncoding;
            var finishedDate = (new DateTime(testRun.FinishedDate, dateTimeEncoding)).GetJSDate();

            $("#testEndDateTime").html(finishedDate.toLocaleDateString() + ", " + finishedDate.toLocaleTimeString());

            var runDuration = testRun.RunSpecificDetails.Duration;

            if (testState.IsAborted() || testState.IsFailed()) {
                if (testRun.ExecutionStartedDate == testRun.CreatedDate) {
                    // This means the test has been aborted before execution started on any Agent
                    $("#runDuration").html(new TimeSpan(0).ToString() + "/" + new TimeSpan(runDuration).ToString());
                }
                else {
                    // Execution has started already
                    var startDate = (new DateTime(testRun.ExecutionStartedDate, dateTimeEncoding)).GetJSDate();
                    var actualDuration = (finishedDate.getTime() - startDate.getTime()) / 1000;
                    (actualDuration < runDuration) ? $("#runDuration").html(new TimeSpan(actualDuration).ToString() + "/" + new TimeSpan(runDuration).ToString()) : $("#runDuration").html(new TimeSpan(runDuration).ToString()) + "/" + $("#runDuration").html(new TimeSpan(runDuration).ToString());
                }
            }
            if (testState.IsCompleted()) {
                $("#runDuration").html(new TimeSpan(runDuration).ToString());
            }
            $("#testCompletedSection").show();
            reportDownloader.DisableDownloadLinkIfRequired(testRunMonitor.GetVSCompatibleTestRun());

        } catch (ex) {
            //Run stats are not available. No need to show download report section.
        }
    }

    function onTestRunError(error) {
        if (testRunMonitor.IsTestRunAvailable()) {
            framework.LogError("Test run error: " + error.message);
            testProgressBar.StopProgress();
            $("#progressBarSection").hide();
            $("#stopButton").hide();
            instance.SetState(testRunMonitor.GetTestState().ToUIString(), error);
            if (framework.GetTestServiceClient().IsIntermittentError(error)) {
                ShowErrorMessage(error.message);
            }
        }
    }

    function downloadResult() {
        $("#infoSection").html("");
        if (!testRunMonitor.IsTestRunAvailable()) {
            return;
        }

        reportDownloader.DownloadResult(testRunMonitor.GetVSCompatibleTestRun());
    }

    function cancelRun() {
        elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_StopRunStart);
        userCancelled = true;
        updateUIToStoppingState(null);
        framework.CancelRun();
    }

    function stopRun() {
        elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_StopRunStart);
        if (!testRunMonitor.IsTestRunAvailable()) {
            return;
        }
        stopInitiated = true;
        // Update initially with the hardcoded values.
        updateUIToStoppingState(null);
        // Update the UI after we get test run after control comes back from stopping client.
        var testRunObject = testRunMonitor.GetVSCompatibleTestRun();
       framework.GetTestServiceClient().StopTestRunById(testRunObject.Id, updateUIToStoppingState);
    }

    function updateUIToStoppingState(testRun) {
        $("#stopButton").prop('disabled', true);
        if (testRun) {
            testRunMonitor.UpdateTestRunInforamtion(testRun);
        }
        else {
            $("#pageTitle").html(resource.GetString("PageTitle", instance.TestName, resource.GetString("TestStatusAborting")));
            framework.ReportCaptionChange(resource.GetString("TestStatusAborting"), -1);
            $("#testSubStatus").html("");
            $("#testStatusImage").attr({
                'src': Plugin.Theme.getValue('TestAborted'),
                'data-plugin-theme-src': 'TestAborted'
            });
            elsFramework.GetCodeMarkers().fire(elsFramework.GetCodeMarkers().CodeMarkerValues.PerfELS_StopRunEnd);
        }
    }

    function showMessagesTab(e, ui) {
        if (ui.panel.id == "messagesSection") {
            if (currentGraph != null)
                currentGraph.Hide();
            if (testRunMessages == null)
                testRunMessages = new TestRunMessages($(".hub-content"), testRunMonitor, framework);
            testRunMessages.Show();
        } else {
            if (testRunMessages != null)
                testRunMessages.Hide();
            if (currentGraph != null) {
                currentGraph.Show();
            }
        }
    }

    function ShowErrorMessage(message) {
        ShowLTRError($("#intermittentErrorDetails"), resource.GetString("ErrorDetailsTag"),
            "<div>" + resource.GetString("LTRIntermittentErrorTitle") + "</div><br><div>" + message + "</div>");
    }

    this.SetTestAbortedView = function (errorMessage) {
        $("#testEndDateTimeLabel").html(resource.GetString("AbortedLabel"));
        if (errorMessage != null) {
            $("#infoSection").html(errorMessage);
        }
        $("#testStatusImage").attr({
            'src': Plugin.Theme.getValue('TestAborted'),
            'data-plugin-theme-src': 'TestAborted'
        });
    };

    this.SetTestFailedView = function (errorMessage) {
        $("#testEndDateTimeLabel").html(resource.GetString("FailedLabel"));
        if (errorMessage != null) {
            $("#infoSection").html(errorMessage);
        }
        $("#testStatusImage").attr({
            'src': Plugin.Theme.getValue('TestFailed'),
            'data-plugin-theme-src': 'TestFailed'
        });
    };

    this.SetState = function (state, errorMsg) {
        if (state == "Error"  || state =="Failed") {
            instance.SetTestFailedView(errorMsg);
        } else if (state == "Aborted") {
            instance.SetTestAbortedView(errorMsg);
        } else {
            return; //Ignore other
        }

        $("#pageTitle").html(resource.GetString("PageTitle", instance.TestName, state));
    };

    this.SetSubState = function (subState) {
        $("#testSubStatus").html(subState);
    };

    this.CancelTest = function(state, message) {
        instance.SetState(state, message);
    };

    this.InitializeTest = function(state) {
        $("#pageTitle").html(resource.GetString("PageTitle", instance.TestName, resource.GetString("TestStatusInitializing")));
        $("#stopButton").show();
        if ($("#testSubStatus").hasClass("status-progress")) {
            $("#testSubStatus").removeClass("status-progress");
        }
    };

    this.ShowTfsConnection = function(tfsUrl) {
        $("#pageTitle").html(resource.GetString("PageTitle", instance.TestName, resource.GetString("ElsConnectionInProgress", tfsUrl)));
    };

    this.UpdateConnectedAccount = function(connectedAccount) {
        instance.TfsUrl = connectedAccount;
        $("#tfsconnectedStatus").html(resource.GetString("TfsConnectedInfo", instance.TfsUrl));
        elsFramework.LogInfo("Updated Connected " + instance.TfsUrl);
    };

    this.ShowLocationInformation = function(location) {
        $('#locationInfo').html(resource.GetString("LocationInfo", location));
        elsFramework.LogInfo("Updated location " + location);
    };
    
    this.TestRunError = function (status, message) {
        loadTestRunning = false;
        $("#testSubStatus").html("");
        instance.SetState(status, message);
        $("#stopButton").hide();

        testProgressBar.StopProgress();
        $("#progressBarSection").hide();

        if ($("#testSubStatus").hasClass("status-progress")) {
            $("#testSubStatus").removeClass("status-progress");
        }
        if (status == "Error") {
        ShowErrorMessage(message);
        }
    };

    this.Initialize = function (fromLtm, isConnectedtoTfs) {
        reportDownloader.Initialize($('#downloadReportLink'));
        $("#testEndDateTimeLabel").html(resource.GetString("CompletedLabel"));
        $("#runDurationLabel").html(resource.GetString("RunDurationLabel"));
        if (!fromLtm) {
            $("#stopButton").html(resource.GetString("StopButtonCaption"));
            if (isConnectedtoTfs) {
                $("#pageTitle").html(resource.GetString("PageTitle", instance.TestName, resource.GetString("TestStatusInitializing")));
                $("#tfsconnectedStatus").html(resource.GetString("TfsConnectedInfo", instance.TfsUrl));
            }
            else {
                $("#pageTitle").html(resource.GetString("PageTitle", instance.TestName, resource.GetString("TfsConnectionInProgress")));
                $("#testSubStatus").html("");
                $("#testSubStatus").addClass("status-progress");
                $("#stopButton").hide();
            }
        }
        else {
            $("#pageTitle").html("");
            $("#pageTitle").addClass("status-progress");
            $("#stopButton").hide();
        }

        testProgressBar = new ProgressTimer($("#progressBar"), $("#progressCurrentTime"), $("#progressTotalTime"));

        $("#stopButton").unbind('click').click(cancelRun);
        $("#downloadReportLink").unbind('click').click(downloadResult);

        testRunMonitor.RegisterTestRunUpdates({
            OnStatusUpdate: onTestStatusUpdate,
            OnSubStatusUpdate: onSubStatusUpdate,
            OnKpiAvailable: onKpiAvailable,
            OnTestRunError: onTestRunError,
            OnTestMessagesReceived: onTestMessagesReceived
        });

        // In case of LTR wait for the test run created 
        if (fromLtm) {
            $("#tfsconnectedStatus").html(resource.GetString("TfsConnectedInfo", instance.TfsUrl));
            this.StartTestRunMonitor();
        }
    };

    this.StartTestRunMonitor = function() {
        if (runMonitorStarted) {
            elsFramework.LogError("Run Monitor already started");
            return;
        }

        testRunMonitor.StartMonitoring($("#testRunId").val(), 5000);
        runMonitorStarted = true;
    };

    this.GetReportDownloadView = function() {
        return reportDownloader;
    };

    this.Shutdown = function () {
        testRunMonitor.StopMonitoring();
    };
}

function onFrameworkReady() {
}

function uiInit(initParam) {
    var f1KeyCode = 112;

    document.getElementById("testRunId").value = initParam.TestRunId;
    $(document).keydown(function (e) {

        // Returning false will prevent propagation of the keydown event when F1 is pressed.
        if (e.keyCode === f1KeyCode) {
            return false;
        }
    });
    testStatusView.TestName = initParam.TestName;
    testStatusView.TfsUrl = initParam.TfsUrl;
    testStatusView.Initialize(initParam.FromLtm, initParam.IsConnected);
}

$(window).load(function () {
    elsFramework.Init({ OnFrameworkReady: onFrameworkReady, OnUIInitialization: uiInit, TestStatusView: testStatusView, DownloadView: testStatusView.GetReportDownloadView() });
});

$(window).unload(function () {
    testStatusView.Shutdown();
    elsFramework.Shutdown();
});

// SIG // Begin signature block
// SIG // MIIaswYJKoZIhvcNAQcCoIIapDCCGqACAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFKErGOD7rDyN
// SIG // mzVF8oa1VlHL6aunoIIVgjCCBMMwggOroAMCAQICEzMA
// SIG // AABvZS1YbQcRRigAAAAAAG8wDQYJKoZIhvcNAQEFBQAw
// SIG // dzELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBMB4XDTE1MDMyMDE3
// SIG // MzIwMloXDTE2MDYyMDE3MzIwMlowgbMxCzAJBgNVBAYT
// SIG // AlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH
// SIG // EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsT
// SIG // Hm5DaXBoZXIgRFNFIEVTTjpDMEY0LTMwODYtREVGODEl
// SIG // MCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3RhbXAgU2Vy
// SIG // dmljZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAM/mbc3BKs2uqF7YlU8tA0NHczu4QtLQV5rd9lM2
// SIG // d9WIRSRqyKvQZumLxaoPnvKDRrYqydg2xvSg/xFvZvBe
// SIG // FBmysWf48V6UhqqOJa/4NRP9gi/HOF5TwHYcxdN5O7Bj
// SIG // 60+TmgXwohdx3MYMltMABS5MbVizf7QsJHB7lmksbIp4
// SIG // CW1JmY46PmaVj09/eBtge1fJUfRLbVHDNLf4OgrWEd/D
// SIG // OqUeoDjc662q+EPEg5qNlzQDNAQa761UNqTUGiz9w27w
// SIG // eOcp8blEwHG0L8QQiwz3NmJ5/QdXfeoFfEyfTjA/J1A4
// SIG // Zga7Xag+xZDb3zx2Vq2VIDRTcu1pWW7wVB9A1TkCAwEA
// SIG // AaOCAQkwggEFMB0GA1UdDgQWBBTypkkpeHxXcFJiz+2s
// SIG // t3sgNEfc/TAfBgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7
// SIG // syuwwzWzDzBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9NaWNyb3NvZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsG
// SIG // AQUFBwEBBEwwSjBIBggrBgEFBQcwAoY8aHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsG
// SIG // AQUFBwMIMA0GCSqGSIb3DQEBBQUAA4IBAQCNs0y22OwN
// SIG // h4YZXuQA55e41c9MCjy991XT9PCgr1VynCOXuYIqxxYK
// SIG // xScTWdDaMCuIQrpSA+ZeySVoJyeNZKdt+beaaqs+rELQ
// SIG // HiQmzFSv9pCBax6tQ58bexBXajI2MaJEaAGYWisStIkx
// SIG // 9kwMrhU8tyQkXbv/fFNMhMQNzUZ3finKn7JGYoK0NMf1
// SIG // EmlcrXnNMe7pR474/FPz5AKQUWvO+p3jhb9ZgFkQ1Wej
// SIG // TKby5KC02ME6oWpIpojOcPapnN7zU5M9cHEA/77rfPz/
// SIG // CGMPS1FZqxUZkHQe/7u9qjWbPZ7zEBTVevYf1uJ185J0
// SIG // Da0W2RLPoZut0hLqADsjFQzPMIIE7DCCA9SgAwIBAgIT
// SIG // MwAAAQosea7XeXumrAABAAABCjANBgkqhkiG9w0BAQUF
// SIG // ADB5MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMSMwIQYDVQQDExpN
// SIG // aWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQTAeFw0xNTA2
// SIG // MDQxNzQyNDVaFw0xNjA5MDQxNzQyNDVaMIGDMQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYD
// SIG // VQQDExVNaWNyb3NvZnQgQ29ycG9yYXRpb24wggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCS/G82u+ED
// SIG // uSjWRtGiYbqlRvtjFj4u+UfSx+ztx5mxJlF1vdrMDwYU
// SIG // EaRsGZ7AX01UieRNUNiNzaFhpXcTmhyn7Q1096dWeego
// SIG // 91PSsXpj4PWUl7fs2Uf4bD3zJYizvArFBKeOfIVIdhxh
// SIG // RqoZxHpii8HCNar7WG/FYwuTSTCBG3vff3xPtEdtX3gc
// SIG // r7b3lhNS77nRTTnlc95ITjwUqpcNOcyLUeFc0Tvwjmfq
// SIG // MGCpTVqdQ73bI7rAD9dLEJ2cTfBRooSq5JynPdaj7woY
// SIG // SKj6sU6lmA5Lv/AU8wDIsEjWW/4414kRLQW6QwJPIgCW
// SIG // Ja19NW6EaKsgGDgo/hyiELGlAgMBAAGjggFgMIIBXDAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDAzAdBgNVHQ4EFgQUif4K
// SIG // MeomzeZtx5GRuZSMohhhNzQwUQYDVR0RBEowSKRGMEQx
// SIG // DTALBgNVBAsTBE1PUFIxMzAxBgNVBAUTKjMxNTk1KzA0
// SIG // MDc5MzUwLTE2ZmEtNGM2MC1iNmJmLTlkMmIxY2QwNTk4
// SIG // NDAfBgNVHSMEGDAWgBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3JsLm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWND
// SIG // b2RTaWdQQ0FfMDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUH
// SIG // AQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNpZ1BD
// SIG // QV8wOC0zMS0yMDEwLmNydDANBgkqhkiG9w0BAQUFAAOC
// SIG // AQEApqhTkd87Af5hXQZa62bwDNj32YTTAFEOENGk0Rco
// SIG // 54wzOCvYQ8YDi3XrM5L0qeJn/QLbpR1OQ0VdG0nj4E8W
// SIG // 8H6P8IgRyoKtpPumqV/1l2DIe8S/fJtp7R+CwfHNjnhL
// SIG // YvXXDRzXUxLWllLvNb0ZjqBAk6EKpS0WnMJGdAjr2/TY
// SIG // pUk2VBIRVQOzexb7R/77aPzARVziPxJ5M6LvgsXeQBkH
// SIG // 7hXFCptZBUGp0JeegZ4DW/xK4xouBaxQRy+M+nnYHiD4
// SIG // BfspaxgU+nIEtwunmmTsEV1PRUmNKRot+9C2CVNfNJTg
// SIG // FsS56nM16Ffv4esWwxjHBrM7z2GE4rZEiZSjhjCCBbww
// SIG // ggOkoAMCAQICCmEzJhoAAAAAADEwDQYJKoZIhvcNAQEF
// SIG // BQAwXzETMBEGCgmSJomT8ixkARkWA2NvbTEZMBcGCgmS
// SIG // JomT8ixkARkWCW1pY3Jvc29mdDEtMCsGA1UEAxMkTWlj
// SIG // cm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5
// SIG // MB4XDTEwMDgzMTIyMTkzMloXDTIwMDgzMTIyMjkzMlow
// SIG // eTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWlj
// SIG // cm9zb2Z0IENvZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqG
// SIG // SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCycllcGTBkvx2a
// SIG // YCAgQpl2U2w+G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/
// SIG // 3sJCTiPVcgDbNVcKicquIEn08GisTUuNpb15S3GbRwfa
// SIG // /SXfnXWIz6pzRH/XgdvzvfI2pMlcRdyvrT3gKGiXGqel
// SIG // cnNW8ReU5P01lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJp
// SIG // L9oZC/6SdCnidi9U3RQwWfjSjWL9y8lfRjFQuScT5EAw
// SIG // z3IpECgixzdOPaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn
// SIG // 0i1i8UU956wIAPZGoZ7RW4wmU+h6qkryRs83PDietHdc
// SIG // pReejcsRj1Y8wawJXwPTAgMBAAGjggFeMIIBWjAPBgNV
// SIG // HRMBAf8EBTADAQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJ
// SIG // Ny4zFha5TJoKHzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGC
// SIG // NxUBBAUCAwEAATAjBgkrBgEEAYI3FQIEFgQU/dExTtMm
// SIG // ipXhmGA7qDFvpjy82C0wGQYJKwYBBAGCNxQCBAweCgBT
// SIG // AHUAYgBDAEEwHwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8
// SIG // KuEKU5VZ5KQwUAYDVR0fBEkwRzBFoEOgQYY/aHR0cDov
// SIG // L2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVj
// SIG // dHMvbWljcm9zb2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUF
// SIG // BwEBBEgwRjBEBggrBgEFBQcwAoY4aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRS
// SIG // b290Q2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggIBAFk5
// SIG // Pn8mRq/rb0CxMrVq6w4vbqhJ9+tfde1MOy3XQ60L/svp
// SIG // LTGjI8x8UJiAIV2sPS9MuqKoVpzjcLu4tPh5tUly9z7q
// SIG // QX/K4QwXaculnCAt+gtQxFbNLeNK0rxw56gNogOlVuC4
// SIG // iktX8pVCnPHz7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y
// SIG // 4k74jKHK6BOlkU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wd
// SIG // zaKMvSeyeWNWRKJRzfnpo1hW3ZsCRUQvX/TartSCMm78
// SIG // pJUT5Otp56miLL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q7
// SIG // 0eFW6NB4lhhcyTUWX92THUmOLb6tNEQc7hAVGgBd3TVb
// SIG // Ic6YxwnuhQ6MT20OE049fClInHLR82zKwexwo1eSV32U
// SIG // jaAbSANa98+jZwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKN
// SIG // MxZlHg6K3RDeZPRvzkbU0xfpecQEtNP7LN8fip6sCvsT
// SIG // J0Ct5PnhqX9GuwdgR2VgQE6wQuxO7bN2edgKNAltHIAx
// SIG // H+IOVN3lofvlRxCtZJj/UBYufL8FIXrilUEnacOTj5XJ
// SIG // jdibIa4NXJzwoq6GaIMMai27dmsAHZat8hZ79haDJLmI
// SIG // z2qoRzEvmtzjcT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq
// SIG // /2mbluIQqBC0N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZo
// SIG // NAAAAAAAHDANBgkqhkiG9w0BAQUFADBfMRMwEQYKCZIm
// SIG // iZPyLGQBGRYDY29tMRkwFwYKCZImiZPyLGQBGRYJbWlj
// SIG // cm9zb2Z0MS0wKwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBD
// SIG // ZXJ0aWZpY2F0ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1
// SIG // MzA5WhcNMjEwNDAzMTMwMzA5WjB3MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBQQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCfoWyx39tIkip8ay4Z4b3i48WZUSNQrc7d
// SIG // GE4kD+7Rp9FMrXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr
// SIG // 6Hu97IkHD/cOBJjwicwfyzMkh53y9GccLPx754gd6udO
// SIG // o6HBI1PKjfpFzwnQXq/QsEIEovmmbJNn1yjcRlOwhtDl
// SIG // KEYuJ6yGT1VSDOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd+
// SIG // +NIT8wi3U21StEWQn0gASkdmEScpZqiX5NMGgUqi+YSn
// SIG // EUcUCYKfhO1VeP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68e
// SIG // eEExd8yb3zuDk6FhArUdDbH895uyAc4iS1T/+QXDwiAL
// SIG // AgMBAAGjggGrMIIBpzAPBgNVHRMBAf8EBTADAQH/MB0G
// SIG // A1UdDgQWBBQjNPjZUkZwCu1A+3b7syuwwzWzDzALBgNV
// SIG // HQ8EBAMCAYYwEAYJKwYBBAGCNxUBBAMCAQAwgZgGA1Ud
// SIG // IwSBkDCBjYAUDqyCYEBWJ5flJRP8KuEKU5VZ5KShY6Rh
// SIG // MF8xEzARBgoJkiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJ
// SIG // k/IsZAEZFgltaWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jv
// SIG // c29mdCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eYIQ
// SIG // ea0WoUqgpa1Mc1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BB
// SIG // hj9odHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2Ny
// SIG // bC9wcm9kdWN0cy9taWNyb3NvZnRyb290Y2VydC5jcmww
// SIG // VAYIKwYBBQUHAQEESDBGMEQGCCsGAQUFBzAChjhodHRw
// SIG // Oi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01p
// SIG // Y3Jvc29mdFJvb3RDZXJ0LmNydDATBgNVHSUEDDAKBggr
// SIG // BgEFBQcDCDANBgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wD
// SIG // RDbd6bStd9vOeVFNAbEudHFbbQwTq86+e4+4LtQSooxt
// SIG // YrhXAstOIBNQmd16QOJXu69YmhzhHQGGrLt48ovQ7DsB
// SIG // 7uK+jwoFyI1I4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mR
// SIG // KiQicPv2/OR4mS4N9wficLwYTp2OawpylbihOZxnLcVR
// SIG // DupiXD8WmIsgP+IHGjL5zDFKdjE9K3ILyOpwPf+FChPf
// SIG // wgphjvDXuBfrTot/xTUrXqO/67x9C0J71FNyIe4wyrt4
// SIG // ZVxbARcKFA7S2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGys
// SIG // OUzU9nm/qhh6YinvopspNAZ3GmLJPR5tH4LwC8csu89D
// SIG // s+X57H2146SodDW4TsVxIxImdgs8UoxxWkZDFLyzs7BN
// SIG // Z8ifQv+AeSGAnhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU
// SIG // 2DKATCYqSCRfWupW76bemZ3KOm+9gSd0BhHudiG/m4LB
// SIG // J1S2sWo9iaF2YbRuoROmv6pH8BJv/YoybLL+31HIjCPJ
// SIG // Zr2dHYcSZAI9La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCl
// SIG // eKuzoJZ1GtmShxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/J
// SIG // mu5J4PcBZW+JC33Iacjmbuqnl84xKf8OxVtc2E0bodj6
// SIG // L54/LlUWa8kTo/0xggSdMIIEmQIBATCBkDB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQQITMwAAAQosea7XeXumrAAB
// SIG // AAABCjAJBgUrDgMCGgUAoIG2MBkGCSqGSIb3DQEJAzEM
// SIG // BgorBgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgor
// SIG // BgEEAYI3AgEVMCMGCSqGSIb3DQEJBDEWBBSRRIBHoAoy
// SIG // eWL+0ylKR0FQVOHcyzBWBgorBgEEAYI3AgEMMUgwRqAs
// SIG // gCoARQBMAFMALgBUAGUAcwB0AFMAdABhAHQAdQBzAFYA
// SIG // aQBlAHcALgBqAHOhFoAUaHR0cDovL21pY3Jvc29mdC5j
// SIG // b20wDQYJKoZIhvcNAQEBBQAEggEAI/hhMrYN5CD/KN8r
// SIG // lI40O9BF7Fu9rEhiE2t78wzZE/UR0tMTGdfZ0v7AyhrB
// SIG // hJ2H89pQaG39k+kNwKxSgA2TWZsQSB2776536r57E7Xs
// SIG // 0yadMopQ5QBV24J0nwz3ieT5ireZ5RhE9YkvdNc/FZsj
// SIG // wJFDknHoEtFj3DfXC0qyIb44m45F+s+6ukKy74tg7HGT
// SIG // iIuPSQl+MPBQwIBVx0tMN6SSYy2zXRtTLphSy9T5u2Ra
// SIG // SiQPFD/xx2lyaEG1s/wnEl9C6gRynJ+DK3QzK3+db8f3
// SIG // 3jhsp6s/g32Sl3i7DiFWUaX00AoiMVC6fKEEPlciJhtT
// SIG // TIQAOG2grJvsa/Y3raGCAigwggIkBgkqhkiG9w0BCQYx
// SIG // ggIVMIICEQIBATCBjjB3MQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MSEwHwYDVQQDExhNaWNyb3NvZnQgVGltZS1TdGFtcCBQ
// SIG // Q0ECEzMAAABvZS1YbQcRRigAAAAAAG8wCQYFKw4DAhoF
// SIG // AKBdMBgGCSqGSIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJ
// SIG // KoZIhvcNAQkFMQ8XDTE1MDYyOTA0MzQyOVowIwYJKoZI
// SIG // hvcNAQkEMRYEFKouZEarbv72w0/75bAkHJCEUbwLMA0G
// SIG // CSqGSIb3DQEBBQUABIIBALc661QsJO5rOyK8ejS5pREN
// SIG // Ft/Nd/8LuRoYJDXv0yLI46zx1MrHbXR1NxkU8xFyRb/3
// SIG // nSKHnsrIXCyj0f9M1ou9mlbtd8v+5MmGkKA+of9U1utZ
// SIG // ctmJQJTZuTRDxWqfD0zBmxFil67VpWq3K1DzvToycb0H
// SIG // mU3EJWCO50G+T1MSxuOqzTNf9jFhSksQJhJri3PdjGGS
// SIG // Hmk1PeVrmKvTBEv0a5xDgA+v2WULWH6ASrrEcwCD5ksq
// SIG // H4VChHZ9i/tNbmkUq+NI5mJ72Xj1CbgitJYzz1pwobUa
// SIG // b4ZlhHFZ6eK70FOPV8TVeXlpwlTwb8RsGOT+9YjyYmoU
// SIG // JOHlyR+ukLI=
// SIG // End signature block
